import java.rmi.*;
import javax.naming.*;
import javax.ejb.*;
import javax.rmi.PortableRemoteObject;
import java.util.Properties;
import Alkindi.Services.BeanIface.*;

public class BeanUtil 
{
	static void printCtxEnv(final Context ctx) throws NamingException
	{
		System.out.println("Context environment:");
		final java.util.Hashtable env = ctx.getEnvironment();
		java.util.Enumeration kenum = env.keys();
		while (kenum.hasMoreElements()) {
			Object key = kenum.nextElement();
			System.out.println(key.toString() + ": " + env.get(key));
		}
	}
	
	static Context getInitCtx()
	{
		Context initCtx = null;
		System.setSecurityManager(new RMISecurityManager());
		System.out.println("Starting BeanUtil");
		try {
			initCtx = new InitialContext();
			System.out.println("BeanUtil got new init ctx.");
			printCtxEnv(initCtx);
		}
		catch(Exception e) {
			System.out.println("Exception in BeanUtil constructor:\n" + e.toString());
			System.exit(1);
		}
		return initCtx;	
	}
	
	static public Object getHomeIface(String IfaceName) throws NamingException
	{
		Context initCtx = getInitCtx();
		Object obj = initCtx.lookup(IfaceName);
		initCtx.close();
		return obj;	
	}

	static public IAccountManagerBean getAcctMgr() throws NamingException, RemoteException, CreateException
	{
		Object obj = getHomeIface("ejb/AcctMgrBean");
		IAccountManagerHome home =  (IAccountManagerHome)PortableRemoteObject.narrow(obj, IAccountManagerHome.class);
		return home.create();
	}
	

	static public IRatingManagerBean getRatMgr() throws NamingException, RemoteException, CreateException
	{
		Object obj = getHomeIface("ejb/RatingMgrBean");
		IRatingManagerHome home = (IRatingManagerHome)PortableRemoteObject.narrow(obj, IRatingManagerHome.class);
		return home.create();
	}

	static public IClusterManagerBean getClusterMgr() throws NamingException, RemoteException, CreateException
	{
		Object obj = getHomeIface("ejb/ClusterMgrBean");
		IClusterManagerHome home = (IClusterManagerHome)PortableRemoteObject.narrow(obj, IClusterManagerHome.class);
		return home.create();
	}

	static public IRecommendationManagerBean getRecMgr() throws NamingException, RemoteException, CreateException
	{
		Object obj = getHomeIface("ejb/RecMgrBean");
		IRecommendationManagerHome home = (IRecommendationManagerHome)PortableRemoteObject.narrow(obj, IRecommendationManagerHome.class);
		return home.create();
	}

	static public ISearchManagerBean getSearchMgr() throws NamingException, RemoteException, CreateException
	{
		Object obj = getHomeIface("ejb/SearchMgrBean");
		ISearchManagerHome home = (ISearchManagerHome)PortableRemoteObject.narrow(obj, ISearchManagerHome.class);
		return home.create();
	}

}
